#Load data
library(tidyverse)
library(PROscorerTools)

dir <- "C:/Users/stajner24/box.fu/Unemployment_Wellbeing/"
#dir <- "/Users/mariolawes/box.fu/Unemployment_Wellbeing/"

dat_all <- haven::read_dta(paste0(dir,"3 Daten/Panel/AuLDataCortisol.dta"))
dat <- dat_all

source(paste0(dir,"/4 Analysen/Generelle Skripte/R/renameVars.R"))


## create POMP scores
dat <- dat %>%
  mutate_at(c("neuro", "extra", "open", "consc", "agree"), rerange100, mn = 1, mx =7) # vars with seven categories

# --------------------- Define Predictors ------------------------------

# Work Hours
dat <- dat %>% 
  mutate(workh_cat = factor(ifelse(dat$workh >= 0 & dat$workh <= 15, 1, # marginal employment
                                   ifelse(dat$workh > 15 & dat$workh <= 35, 2, # part-time employment
                                          ifelse(dat$workh > 35, 3, # full-time employment
                                                 ifelse(dat$workh == -9, 4, # flexible working hours
                                                        NA)))),
                            levels = c(3,1,2, 4),
                            labels = c("full-time employment", "marginal employment", "part-time employment",  "flexible working hours")),
         longHours = ifelse(dat$overtime_none == 1, 1, 0))

# Employment-related Expectations
dat <- dat %>% 
  mutate(newJob         = ifelse(lookforNewJob > 5, 1, 0),
         loseJob        = ifelse(loseJob > 5, 1, 0),
         changeJob      = ifelse(changeOcc > 5, 1, 0),
         changeSelfEmp  = ifelse(changeSelfEmpl > 5, 1, 0),
         changeParttime = ifelse(changeParttime > 5, 1, 0),
         endEMP         = ifelse(endEmployment > 5, 1, 0))

# Study Specifics 
dat <- dat %>%
  mutate(contactCat = factor(ifelse(contact ==1,1, # Early Recruitment Waves (Letter)
                                    ifelse(contact  %in% c(2,6,7,8), 2, # Letter (no email available)
                                           ifelse(contact == 3, 3, # Email,
                                                  ifelse(contact  == 4,4, # Pre-Announcement (email available)
                                                         ifelse(contact == 5, 5, # Letter (email available)
                                                                NA))))),
                             levels = c(2, 1, 3:5),
                             labels = c("Letter (no email available)","Early Recruitment Waves (Letter)",  "Email", "Pre-Announcement (email available)", "Letter(email available)")),
         contactCat = relevel(contactCat, ref="Letter (no email available)"),
         reasonCat = factor(ifelse(dat$reason %in% 1:4, 1, # "Plant Closure or Mass-Layoff",
                                    ifelse(dat$reason == 6, 2, #  "Expired Contract",                                                   
                                           ifelse(is.na(dat$reason), NA, 3 # "otherReason"
                                           ))),
                             levels = 1:3,
                             labels = c("Plant Closure OR Mass-Layoff",
                                        "Expired Contract",
                                        "Other Reason")),
         atLeastOneItem = ifelse(rate > 0, 1,0),
         atLeast80Perc = ifelse(dat$rate >= 0.8,1,0))


# --------------------- Define Cortisol Outcomes ------------------------------

eligable_outcomes <- c("Hair Probe was Recieved", "Collection Kit was sent out but no Hair was sent in", "Eligable but No Hair Collection Kit was Send Out")
dat <- dat %>%
  group_by(userId) %>%
  mutate(cortisolStatus = ifelse(sendInHair == 1, "Hair Probe was Recieved",
                                 ifelse(sendInHair == 0 & requestedCortisolKit == 1, "Collection Kit was sent out but no Hair was sent in",
                                        ifelse(cortisol_drugs == 1 & !is.na(cortisol_drugs), "Excluded due to Cortison Medication",
                                               ifelse(cortisol_hair_length == 1 & !is.na(cortisol_hair_length), "Excluded due to Short Hair",
                                                      ifelse(cortisol_consent == 0 & !is.na(cortisol_consent), "Not Interested in Cortisol Study" ,
                                                             ifelse(cortisol_drugs == 0 & requestedCortisolKit == 0 & !is.na(cortisol_drugs), "Eligable but No Hair Collection Kit was Send Out" ,
                                                                    ifelse(atLeastOneItem == 1 & is.na(cortisol_consent), "Active, but Missed the Cortisol Questionaire",
                                                                           ifelse(atLeastOneItem == 0, "Not Active", NA)))))))),
         interestedANDeligableM1 = ifelse(month == 1 & cortisolStatus %in% eligable_outcomes, 1, 0),
         interestedANDeligableM1 = max(interestedANDeligableM1),
         cortisolStatus = ifelse(month %in% c(4,7,10,13) & interestedANDeligableM1 == 0 & atLeastOneItem == 1, "Active, but excluded due to no intrest/eligibilty in wave 1",cortisolStatus),
         cortisolStatus = ifelse(userId == "LLlV2bcnerVROwXT" & month == 1, "Excluded Because Closed Questionaire after Indicating Interest", cortisolStatus)) %>% # this subject swiped app away after indicating their interest
  ungroup() %>%
  mutate(cortisolStatus = factor(cortisolStatus,
                                 levels = c(
                                   "Hair Probe was Recieved",
                                   "Collection Kit was sent out but no Hair was sent in",
                                   "Eligable but No Hair Collection Kit was Send Out",
                                   "Excluded due to Cortison Medication",
                                   "Excluded due to Short Hair",
                                   "Excluded Because Closed Questionaire after Indicating Interest",
                                   "Not Interested in Cortisol Study",
                                   "Active, but Missed the Cortisol Questionaire",
                                   "Active, but excluded due to no intrest/eligibilty in wave 1",
                                   "Not Active")))

dat <- dat %>%
  mutate(female = ifelse(gender == 1, 1, 0),
         male = ifelse(gender == 2, 1, 0),
         otherGender = ifelse(gender == 3, 1, 0))

saveRDS(dat, file = "dat.RDS")

